#!/bin/bash -e

# Function to check and delete iptables rules
delete_iptables_rules() {
    local version=$1
    local cmd=ip${version}tables
    local chain_name="AWS"
    
    # Check if the chain exists
    if $cmd -n --list $chain_name >/dev/null 2>&1; then
        echo "Deleting rules from $cmd chain $chain_name"

        # Get all rules from the AWS chain and delete them one by one
        local rules
        rules=$($cmd -S $chain_name | grep "REJECT" || true)

        if [[ -z $rules ]]; then
            echo "No REJECT rules found in $cmd chain $chain_name."
        else
            while IFS= read -r rule; do
                local rule_num
                rule_num=$(echo "$rule" | awk '{print $1}')
                $cmd -D $chain_name "$rule_num"
            done <<< "$rules"
        fi
    else
        echo "Chain $chain_name does not exist in $cmd."
    fi
}

# Function to flush and delete a chain
flush_and_delete_chain() {
    local version=$1
    local cmd=ip${version}tables
    local chain_name="AWS"

    if $cmd -n --list $chain_name >/dev/null 2>&1; then
        echo "Flushing and deleting chain $cmd $chain_name"

        $cmd -F $chain_name
        $cmd -X $chain_name
    else
        echo "Chain $chain_name does not exist in $cmd."
    fi
}

# Delete rules and chains for IPv4
delete_iptables_rules ""
flush_and_delete_chain ""

# Delete rules and chains for IPv6
delete_iptables_rules 6
flush_and_delete_chain 6

echo "Unblocking complete."

